function res = psnr(f,g)
% Peak Signal-To-Noise Ratio (PSNR)
% 
% Given the original (f) and the reconstructed/distorted image (g), this
% function returns the PSNR. Code is copied from [1]. 
% 
% References:
% [1] R. Timofte, V. De Smet, L. van Gool. Anchored Neighborhood Regression 
% for Fast Example-Based Super- Resolution. ICCV 2013. 

F = im2double(f); % original
G = im2double(g); % distorted
E = F - G; % error signal
N = numel(E); % Assume the original signal is at peak (|F|=1)
res = 10*log10( N / sum(E(:).^2) ); % = 1 / (1/N*sum(E(:).^2)!
end