clear all
clc

SRF = 2;%Super-Resolution Factor
rmBorder = SRF;

PSNR=zeros(1,5);
SSIM=zeros(1,5);

I0 = imread('baby[1-Original].bmp');
I1 = imread('layer3img000.bmp');
I0 = cropBorder( I0, rmBorder );
I1 = cropBorder( I1, rmBorder );
PSNR(1) = psnr(I0, I1);
SSIM(1) = ssim_index(I0, I1);

I0 = imread('bird[1-Original].bmp');
I1 = imread('layer3img001.bmp');
I0 = cropBorder( I0, rmBorder );
I1 = cropBorder( I1, rmBorder );
PSNR(2) = psnr(I0, I1);
SSIM(2) = ssim_index(I0, I1);

I0 = imread('butterfly[1-Original].bmp');
I1 = imread('layer3img002.bmp');
I0 = cropBorder( I0, rmBorder );
I1 = cropBorder( I1, rmBorder );
PSNR(3) = psnr(I0, I1);
SSIM(3) = ssim_index(I0, I1);

I0 = imread('head[1-Original].bmp');
I1 = imread('layer3img003.bmp');
I0 = cropBorder( I0, rmBorder );
I1 = cropBorder( I1, rmBorder );
PSNR(4) = psnr(I0, I1);
SSIM(4) = ssim_index(I0, I1);

I0 = imread('woman[1-Original].bmp');
I1 = imread('layer3img004.bmp');
I0 = cropBorder( I0, rmBorder );
I1 = cropBorder( I1, rmBorder );
PSNR(5) = psnr(I0, I1);
SSIM(5) = ssim_index(I0, I1);

PSNR=PSNR';
SSIM=SSIM';

mPSNR = mean(PSNR)
mSSIM = mean(SSIM)