clear all
clc

List =dir('*.bmp');

downsampleFactor = 2;

k =length(List);
for i=1:1:k
     I=imread(List(i).name);
     
     [sy sx ch]  =   size(I);
      
     %% Enable if they are color images
     if ch==3
        im_l_ycbcr = rgb2ycbcr(I);
        I = im_l_ycbcr(:, :, 1);
     end
     %%

     if downsampleFactor==2
        [sy sx] = size(I);
        if mod(sy,2)==1
            I = I(1:sy-1,1:sx);
        end
     
        [sy sx] = size(I);
        if mod(sx,2)==1
            I = I(1:sy,1:sx-1);
        end
     elseif downsampleFactor==3
        [sy sx] = size(I);
        if mod(sy,3)==1
            I = I(1:sy-1,1:sx);
        elseif mod(sy,3)==2
            I = I(1:sy-2,1:sx);
        end
     
        [sy sx] = size(I);
        if mod(sx,3)==1
            I = I(1:sy,1:sx-1);
        elseif mod(sx,3)==2
            I = I(1:sy,1:sx-2);
        end
     end

        
     I = imresize(I, 1/downsampleFactor,'bicubic');
     imwrite(I,strcat(num2str(13,'LR_%.3d'),'.bmp'));

     I = imresize(I, downsampleFactor,'bicubic');
     imwrite(I,strcat(num2str(i,'Bicubic_%.3d'),'.bmp')); 
end